<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class BaseSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Site Name',
                'config_key' => 'app-name',
                'type' => 'string',
                'validation_rules' => 'required',
                'description' => 'Name of the site. Used in meta information for site',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Site Logo',
                'config_key' => 'site-logo',
                'type' => 'image',
                'validation_rules' => 'required',
                'choices' => ".svg,.png",
                'description' => 'Logo of your website. Will be displayed throughout site. Please upload in SVG format',
                'order' => 2,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Site Favicon',
                'config_key' => 'site-favicon',
                'type' => 'image',
                'choices' => '.ico',
                'validation_rules' => "required",
                'description' => 'Favicon (thumbnail icon) shown in browser tab. *.ico file',
                'order' => 3,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Apple Touch Icon',
                'config_key' => 'site-apple-touch-icon',
                'type' => 'image',
                'validation_rules' => "required",
                'choices' => '.png',
                'description' => 'Apple touch icon- an image shown when website is pinned to home screen. *.png file, 180x180px',
                'order' => 4,
            ],
            [
                'tab' => 'Site',
                'section' => 'Mail',
                'group' => 'Contact Details',
                'name' => 'Email Sender Name',
                'config_key' => 'mail-from-name',
                'type' => 'string',
                'validation_rules' => 'required',
                'description' => 'Name used on email sender for outgoing emails (e.g. MySite)',
            ],
            [
                'tab' => 'Site',
                'section' => 'Mail',
                'group' => 'Contact Details',
                'name' => 'Email sending address',
                'config_key' => 'mail-from-email',
                'type' => 'string',
                'validation_rules' => 'required|email',
                'description' => 'Email address that will be used to send emails from site. Will require mail config',
            ],
            [
                'tab' => 'Site',
                'section' => 'Mail',
                'group' => 'Mail Sending',
                'name' => 'SMTP server host',
                'config_key' => 'mail-smtp-host',
                'type' => 'string',
                'validation_rules' => null,
                'description' => 'Host for mail server that will be sending emails',
            ],
            [
                'tab' => 'Site',
                'section' => 'Mail',
                'group' => 'Mail Sending',
                'name' => 'SMTP server port',
                'config_key' => 'mail-smtp-port',
                'value' => 587,
                'type' => 'int',
                'validation_rules' => null,
                'description' => 'Port for mail server that will be sending emails',
            ],
            [
                'tab' => 'Site',
                'section' => 'Mail',
                'group' => 'Mail Sending',
                'name' => 'SMTP server username',
                'config_key' => 'mail-smtp-username',
                'type' => 'string',
                'validation_rules' => null,
                'description' => 'Username for mail server that will be sending emails',
            ],
            [
                'tab' => 'Site',
                'section' => 'Mail',
                'group' => 'Mail Sending',
                'name' => 'SMTP server password',
                'config_key' => 'mail-smtp-password',
                'type' => 'secret',
                'validation_rules' => null,
                'description' => 'Password for mail server that will be sending emails',
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Contact email address',
                'config_key' => 'app-contact-contact_email',
                'type' => 'string',
                'validation_rules' => 'required|email',
                'description' => 'Email address used for contact details and default enquiry submission',
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Contact phone number',
                'config_key' => 'app-contact-phone_number',
                'type' => 'string',
                'validation_rules' => 'required',
                'description' => 'Contact phone number displayed on site',
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Site Currency',
                'config_key' => 'app-details-currency',
                'value' => 'GBP',
                'type' => 'string',
                'validation_rules' => 'required',
                'description' => 'Primary Currency used for the site',
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Phone Number format',
                'config_key' => 'app-phone-number-format',
                'value' => '3-3-4',
                'type' => 'string',
                'choices' => [
                    ['value' => '3-3-4', 'name' => 'XXX-YYY-ZZZZ'],
                    ['value' => '4-3-3', 'name' => 'XXXX-YYY-ZZZ'],
                ],
                'validation_rules' => 'required',
                'description' => 'Way of displaying phone mumbers',
            ],
            [
                'tab' => 'Site',
                'section' => 'Social Media',
                'group' => 'Social Media Icons',
                'name' => 'Facebook',
                'config_key' => 'app-socials-facebook',
                'value' => '',
                'type' => 'string',
                'description' => 'Link to the linked Facebook profile',
            ],
            [
                'tab' => 'Site',
                'section' => 'Social Media',
                'group' => 'Social Media Icons',
                'name' => 'Twitter',
                'config_key' => 'app-socials-twitter',
                'value' => '',
                'type' => 'string',
                'description' => 'Link to the linked Twitter profile',
            ],
            [
                'tab' => 'Site',
                'section' => 'Social Media',
                'group' => 'Social Media Icons',
                'name' => 'YouTube',
                'config_key' => 'app-socials-youtube',
                'value' => '',
                'type' => 'string',
                'description' => 'Link to the linked YouTube profile',
            ],
            [
                'tab' => 'Site',
                'section' => 'Social Media',
                'group' => 'Social Media Icons',
                'name' => 'Instagram',
                'config_key' => 'app-socials-instagram',
                'value' => '',
                'type' => 'string',
                'description' => 'Link to the linked Instagram profile',
            ],
            [
                'tab' => 'Site',
                'section' => 'Social Media',
                'group' => 'Social Media Icons',
                'name' => 'LinkedIn',
                'config_key' => 'app-socials-linkedin',
                'value' => '',
                'type' => 'string',
                'description' => 'Link to the linked LinkedIn profile',
            ],
        ];
    }
}
