<?php

namespace App\Console\Commands;

use App\Jobs\RunScheduledSyncTask;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class SyncVehicles extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sync:vehicles';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync vehicles for tenant from stock providers';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->dispatch(new RunScheduledSyncTask());
        return 0;
    }
}
