<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Setting;

class LinkedInTrackingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Tracking',
                'group' => 'Tracking Pixels',
                'name' => 'LinkedIn code',
                'config_key' => 'tracking-linkedin-code',
                'type' => 'secret',
                'value' => '',
                'description' => '<a href="https://business.linkedin.com/marketing-solutions/conversion-tracking" target="_blank">LinkedIn</a> ads pixel.'
                    . ' Please <em>enter the unique code only</em>!',
            ],
        ];
    }
}
