<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;
use Mtc\Reports\Contracts\ReportModel;

class ReportExport implements FromCollection, WithHeadings, ShouldAutoSize, WithStrictNullComparison
{
    public function __construct(protected Collection $data, protected ReportModel $report)
    {
        //
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return $this->data;
    }

    /**
     * Heading row
     *
     * @return string[]
     */
    public function headings(): array
    {
        $columns = App::make(config('reports.types.' . $this->report->type))->columns();
        return $this->data->first()
            ->map(fn ($value, $key) => $columns[$key] ?? $key)
            ->toArray();
    }
}
