<?php

namespace App\Jobs;

use App\Exports\EbayMotorsExport;
use App\IntegrationRepository;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Tenant;

class EbayMotorsExportJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->onQueue('export');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
            $filename = config('filesystems.disks.ebay-motors-export.filename');

            $export = new EbayMotorsExport();

            Excel::store(
                $export,
                $filename,
                'ebay-motors-export'
            );

            // With SFTP accounts we need to check for file existing as put will not throw an error,
            // but exists check will throw an error on failure
        try {
            Storage::disk('ebay-motors-export')->exists($filename);
        } catch (Exception $exception) {
            Log::warning('Ebay Motors export error: ' . $exception->getMessage());
        }
    }
}
