<?php

namespace Database\Seeders\Tenant;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\ContentElement;
use Mtc\ContentManager\Models\Template;

class NewCarPageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->elements();
        $this->template();
    }

    private function template(): void
    {
        $template = Template::query()->create([
        'name' => 'New Car Page',
        'slug' => 'new-car-page',
        'status' => 1,
        ]);
        collect([
            [
                'name' => 'Scroll Navigation',
                'field_type' => 'element',
                'element_id' => ContentElement::query()->where('slug', 'scroll-navigation')->first()?->id,
                'data' => '{"icon":"layer-group","nestable":true,"component":null,"componentName":false,"nestedLimit":4,"editable":true,"repeatable":true,"isGroup":true,"slug":"scroll-navigation","globalContent":false,"validation":[],"data":[],"isRepeatable":true}',
                'meta' => '[]',
            ],
            [
                'name' => 'Text Block',
                'field_type' => 'element',
                'element_id' => ContentElement::query()->where('slug', 'text-block')->first()?->id,
                'data' => '{"icon":"text","nestable":true,"component":null,"componentName":false,"nestedLimit":4,"editable":true,"repeatable":true,"isGroup":true,"slug":"text-block","globalContent":false,"validation":[],"data":[],"isRepeatable":true}',
                'meta' => '[]',
            ],
            [
                'name' => 'Accordion Content Block',
                'field_type' => 'element',
                'element_id' => ContentElement::query()->where('slug', 'accordion-content-block')->first()?->id,
                'data' => '{"icon":"layer-group","nestable":true,"component":null,"componentName":false,"nestedLimit":4,"editable":true,"repeatable":true,"isGroup":true,"slug":"accordion-content-block","globalContent":false,"validation":[],"data":[],"isRepeatable":true}',
                'meta' => '[]',
            ],
            [
                'name' => 'Feature Cards',
                'field_type' => 'element',
                'element_id' => ContentElement::query()->where('slug', 'feature-cards')->first()?->id,
                'data' => '{"icon":"layer-group","nestable":true,"component":null,"componentName":false,"nestedLimit":4,"editable":true,"repeatable":true,"isGroup":true,"slug":"feature-cards","globalContent":false,"validation":[],"data":[],"isRepeatable":true}',
                'meta' => '[]',
            ],
            [
                'name' => 'Content Block',
                'field_type' => 'element',
                'element_id' => ContentElement::query()->where('slug', 'content-block')->first()?->id,
                'data' => '{"icon":"pencil","nestable":true,"componentName":false,"nestedLimit":4,"editable":true,"repeatable":true,"slug":"content-block","isGroup":true,"globalContent":false,"validation":[],"data":[],"isRepeatable":true}',
                'meta' => '[]',
            ],
            [
                'name' => 'Tab Gallery',
                'field_type' => 'element',
                'element_id' => ContentElement::query()->where('slug', 'tab-gallery')->first()?->id,
                'data' => '{"icon":"image","nestable":true,"component":null,"componentName":false,"nestedLimit":4,"editable":true,"repeatable":true,"isGroup":true,"slug":"tab-gallery","globalContent":false,"validation":[],"data":[],"isRepeatable":true}',
                'meta' => '[]',
            ],
        ])
        ->each(function ($element) use ($template) {
            $element['template_id'] = $template->id;
            $element['data'] = json_decode($element['data'], true);
            $element['meta'] = json_decode($element['meta'], true);
            $template->elements()->create($element);
        });
    }

    private function elements(): void
    {
        $data = collect([
            [
                'title' => 'Content Block',
                'slug' => 'content-block',
                'category' => 'content',
                'ui_component' => 'UiContentBlock',
                'icon' => 'pencil',
                'data' => [],
                'fields' => [
                    [
                        'field_type' => 'text',
                        'name' => 'Title',
                        'slug' => 'title',
                        'data' => '{"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false,"validation":[]}',
                        'meta' => '[]',
                    ],
                    [
                        'field_type' => 'image',
                        'name' => 'Image',
                        'slug' => 'image',
                        'data' => '{"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false,"validation":[]}',
                        'meta' => '{"options":{"required":true,"maxCount":"1","width":"796","height":"550"}}',
                    ],
                    [
                        'field_type' => 'editor',
                        'name' => 'Text',
                        'slug' => 'text',
                        'data' => '{"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false,"validation":[]}',
                        'meta' => '[]',
                        ],
                        [
                        'field_type' => 'boolean',
                        'name' => 'Reversed',
                        'slug' => 'reversed',
                        'data' => '{"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false,"validation":[]}',
                        'meta' => '[]',
                    ],
                ],
            ],
            [
                'title' => 'Accordion Item',
                'slug' => 'accordion-item',
                'category' => 'supporting',
                'ui_component' => 'UiAccordionItem',
                'icon' => 'pencil',
                'data' => [],
                'fields' => [
                    [
                        'field_type' => 'text',
                        'name' => 'Title',
                        'slug' => 'title',
                        'data' => '{"child_element_id":null,"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false}',
                        'meta' => '[]',
                    ],
                    [
                        'field_type' => 'editor',
                        'name' => 'Text',
                        'slug' => 'text',
                        'data' => '{"child_element_id":null,"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false}',
                        'meta' => '[]',
                    ],
                ],
            ],
            [
                'title' => 'Accordion',
                'slug' => 'accordion',
                'category' => 'content',
                'ui_component' => 'UiAccordion',
                'icon' => 'layer-group',
                'data' => [],
                'fields' => [
                    [
                        'field_type' => 'element',
                        'name' => 'Accordion Item',
                        'slug' => 'accordion-item',
                        'child_element_id' => 'accordion-item',
                        'data' => '{"icon":"pencil","nestable":true,"componentName":false,"nestedLimit":4,"editable":true,"repeatable":true,"slug":"accordion-item","isGroup":true,"globalContent":false,"validation":[],"isRepeatable":true,"child_element_id":16}',
                        'meta' => '[]',
                    ],
                ],
            ],
            [
                'title' => 'Accordion Content Block',
                'slug' => 'accordion-content-block',
                'category' => 'content',
                'ui_component' => 'UiAccordionContentBlock',
                'icon' => 'layer-group',
                'data' => [],
                'fields' => [
                    [
                        'field_type' => 'element',
                        'name' => 'Accordion',
                        'slug' => 'accordion',
                        'child_element_id' => 'accordion',
                        'data' => '{"icon":"layer-group","nestable":true,"componentName":false,"nestedLimit":4,"editable":true,"repeatable":true,"slug":"accordion","isGroup":true,"globalContent":false,"validation":[],"isRepeatable":true,"child_element_id":17}',
                        'meta' => '[]',
                    ],
                    [
                        'field_type' => 'image',
                        'name' => 'Image',
                        'slug' => 'image',
                        'data' => '{"child_element_id":null,"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false}',
                        'meta' => '{"options":{"required":true,"maxCount":"1","width":"796","height":"550"}}',
                    ],
                    [
                        'field_type' => 'boolean',
                        'name' => 'Reversed',
                        'slug' => 'reversed',
                        'data' => '{"child_element_id":null,"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false}',
                        'meta' => '[]',
                    ],
                ],
            ],
            [
                'title' => 'Text Block',
                'slug' => 'text-block',
                'category' => 'content',
                'ui_component' => 'UiTextBlock',
                'icon' => 'text',
                'data' => [],
                'fields' => [
                    [
                        'field_type' => 'text',
                        'name' => 'Title',
                        'slug' => 'title',
                        'data' => '{"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false,"validation":[]}',
                        'meta' => '[]',
                    ],
                    [
                        'field_type' => 'editor',
                        'name' => 'Text',
                        'slug' => 'text',
                        'data' => '{"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false,"validation":[]}',
                        'meta' => '[]',
                    ],
                ],
            ],
            [
                'title' => 'Tab Gallery Section',
                'slug' => 'tab-gallery-section',
                'category' => 'supporting',
                'ui_component' => 'UiTabGallerySection',
                'icon' => 'image',
                'data' => [],
                'fields' => [
                    [
                        'field_type' => 'text',
                        'name' => 'Title',
                        'slug' => 'title',
                        'data' => '{"child_element_id":null,"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false}',
                        'meta' => '[]',
                    ],
                    [
                        'field_type' => 'image',
                        'name' => 'Images',
                        'slug' => 'images',
                        'data' => '{"child_element_id":null,"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false}',
                        'meta' => '[]',
                    ],
                ],
            ],
            [
                'title' => 'Tab Gallery',
                'slug' => 'tab-gallery',
                'category' => 'content',
                'ui_component' => 'UiTabGallery',
                'icon' => 'image',
                'data' => [],
                'fields' => [
                    [
                        'field_type' => 'element',
                        'name' => 'Tab Gallery Section',
                        'slug' => 'tab-gallery-section',
                        'child_element_id' => 'tab-gallery-section',
                        'data' => '{"icon":"image","nestable":true,"componentName":false,"nestedLimit":4,"editable":true,"repeatable":true,"slug":"tab-gallery-section","isGroup":true,"globalContent":false,"validation":[],"isRepeatable":true,"child_element_id":20}',
                        'meta' => '[]',
                    ],
                ],
            ],
            [
                'title' => 'Feature Card',
                'slug' => 'feature-card',
                'category' => 'supporting',
                'ui_component' => 'UiFeatureCard',
                'icon' => 'pencil',
                'data' => [],
                'fields' => [
                    [
                        'field_type' => 'text',
                        'name' => 'Title',
                        'slug' => 'title',
                        'data' => '{"child_element_id":null,"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false}',
                        'meta' => '[]',
                    ],
                    [
                        'field_type' => 'editor',
                        'name' => 'Text',
                        'slug' => 'text',
                        'data' => '{"child_element_id":null,"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false}',
                        'meta' => '[]',
                    ],
                    [
                        'field_type' => 'image',
                        'name' => 'Image',
                        'slug' => 'image',
                        'data' => '{"child_element_id":null,"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false}',
                        'meta' => '{"options":{"maxCount":"1","width":"448","height":"281"}}',
                    ],
                ],
            ],
            [
                'title' => 'Feature Cards',
                'slug' => 'feature-cards',
                'category' => 'content',
                'ui_component' => 'UiFeatureCards',
                'icon' => 'layer-group',
                'data' => [],
                'fields' => [
                    [
                        'field_type' => 'element',
                        'name' => 'Feature Card',
                        'slug' => 'feature-card',
                        'child_element_id' => 'feature-card',
                        'data' => '{"icon":"pencil","nestable":true,"componentName":false,"nestedLimit":4,"editable":true,"repeatable":true,"slug":"feature-card","isGroup":true,"globalContent":false,"validation":[],"isRepeatable":true,"child_element_id":22}',
                        'meta' => '[]',
                    ],
                ],
            ],
            [
                'title' => 'Scroll Navigation Item',
                'slug' => 'scroll-navigation-item',
                'category' => 'supporting',
                'ui_component' => 'UiActionBarItem',
                'icon' => 'font-case',
                'data' => [],
                'fields' => [
                    [
                        'field_type' => 'text',
                        'name' => 'Title',
                        'slug' => 'title',
                        'data' => '{"child_element_id":null,"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false}',
                        'meta' => '[]',
                    ],
                    [
                        'field_type' => 'text',
                        'name' => 'Content Block Title',
                        'slug' => 'content-block-title',
                        'data' => '{"child_element_id":null,"nestable":false,"nestedLimit":null,"editable":true,"repeatable":false}',
                        'meta' => '[]',
                    ],
                ],
            ],
            [
                'title' => 'Scroll Navigation',
                'slug' => 'scroll-navigation',
                'category' => 'content',
                'ui_component' => 'UiActionBar',
                'icon' => 'layer-group',
                'data' => [],
                'fields' => [
                    [
                        'field_type' => 'element',
                        'name' => 'Scroll Navigation Item',
                        'slug' => 'scroll-navigation-item',
                        'child_element_id' => 'scroll-navigation-item',
                        'data' => '{"icon":"font-case","nestable":true,"componentName":false,"nestedLimit":4,"editable":true,"repeatable":true,"slug":"scroll-navigation-item","isGroup":true,"globalContent":false,"validation":[],"isRepeatable":true,"child_element_id":24}',
                        'meta' => '[]',
                    ],
                ],
            ],
        ]);
        $data->each(function ($entry) {
            $element = ContentElement::query()->create($entry);
            collect($entry['fields'] ?? [])
                ->each(function ($field) use ($element) {
                    if (!empty($field['child_element_id'])) {
                        $field['child_element_id'] = ContentElement::query()
                            ->where('slug', $field['child_element_id'])
                            ->firstOrFail()
                            ->id;
                    }
                    $field['data'] = json_decode($field['data'], true);
                    $field['meta'] = json_decode($field['meta'], true);
                    $element->fields()->create($field);
                });
        });
    }
}
