<?php

namespace App\Modules\Leasing\Jobs;

use Mtc\MercuryDataModels\KeyloopLeaseColour;

class ImportColoursJob extends BaseImportJob
{
    protected function importItem(array $item)
    {
        KeyloopLeaseColour::query()->updateOrCreate([
            'make_id' => $item['make_id'],
            'colour_code' => $item['colour_code'],
        ], [
            'generic_colour_code' => $item['generic_colour_code'],
            'name' => $item['name'],
            'was_recently_synced' => true,
        ]);
    }
}
