<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ChristmasSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Christmas mode',
                'config_key' => 'christmas-enabled',
                'type' => 'boolean',
                'value' => false,
                'min_tier' => 'enterprise',
                'description' => 'Enable Christmas mode on the website to unlock festive features and decorations.',
                'order' => 11,
            ],
        ];
    }
}
