<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OfferEnquiryTitleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'enquiryMax',
                'name' => 'Append offer type to enquiry title',
                'config_key' => 'crm-enquiry-max-append-offer-type-to-enquiry-title',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Include the offer type in the enquiry title e.g. "New Car Enquiry - Corporate"',
            ],
        ];
    }
}
