<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Mtc\Reports\Contracts\ReportModel;

class Report extends ReportModel
{
    /**
     * Get the next scheduled datetime for the report
     *
     * @param Carbon $from
     * @return mixed
     */
    public function getNextDueAt(Carbon $from)
    {
        return App::make(Config::get('reports.schedule_types.' . $this->schedule))
            ->nextTime($from, $this);
    }
}
