<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutosOnShowRemoveImageSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'AutosOnShow',
                'name' => 'Remove non-AOS images from vehicles',
                'config_key' => 'image-sync-autos-on-show-remove-other-images',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Will remove images from other sources when importing images from AutosOnShow'
            ],
        ];
    }
}
