<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CustomFeedSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Custom Data feed',
                'name' => 'Enabled',
                'config_key' => 'stock-endpoint-enabled',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
                'order' => 1,
                'description' => 'Custom data feed',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Custom Data feed',
                'name' => 'Provider',
                'config_key' => 'stock-endpoint-provider',
                'type' => 'string',
                'min_tier' => 'pro',
                'value' => '',
                'order' => 2,
                'description' => 'Feed mapping',
                'validation_rules' => [
                    "required_if:values.stock-endpoint-enabled,true"
                ]
            ],
        ];
    }
}
