<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OfferRelevanceOrderingSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Custom ordering attribute',
                'config_key' => 'offers-custom-order-attribute',
                'description' => 'Allow creating custom default order for offers when attribute is selected (e.g. - electric offers)',
                'type' => 'string',
                'choices' => [
                    [ 'name' => 'Offer Type', 'value' => 'type_id'],
                    [ 'name' => 'Vehicle Make', 'value' => 'make_id'],
                ],
                'value' => 'type_id',
                'order' => 299
            ],
        ];
    }
}
