<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SimilarVehicleCatalogOfferSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Inject offers into similar vehicle list',
                'config_key' => 'vehicles-inject-offers-into-cross-sell',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
