<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleSpecMotorCheckSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'MotorCheck',
                'name' => 'MotorCheck Vehicle Specs Enabled',
                'config_key' => 'vehicle-spec-providers-motor-check-enabled',
                'min_tier' => 'standard',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'MotorCheck',
                'name' => 'MotorCheck Client Id',
                'config_key' => 'vehicle-spec-providers-motor-check-client_id',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.vehicle-spec-providers-motor-check-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'MotorCheck',
                'name' => 'MotorCheck Client Secret',
                'config_key' => 'vehicle-spec-providers-motor-check-client_secret',
                'min_tier' => 'standard',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.vehicle-spec-providers-motor-check-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'MotorCheck',
                'name' => 'Verify integration',
                'config_key' => 'vehicle-spec-providers-motor-check-verify',
                'min_tier' => 'standard',
                'type' => 'verify',
                'value' => false,
            ],
        ];
    }
}
