<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Mtc\MercuryDataModels\ReportingStat;

class ClearOldReportingStats extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'clear:stats';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove old stats from history';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        ReportingStat::query()
            ->where('date', '<=', Carbon::now()->subDays(config('automotive.dashboard-history-length')))
            ->delete();
        return 0;
    }
}
