<?php

namespace App\Http\Controllers;

use App\Http\Requests\ExportMapTemplateRequest;
use App\Http\Requests\StoreExportMapTemplate;
use App\Http\Requests\UpdateExportMapTemplate;
use App\Http\Resources\ExportMapTemplateList;
use App\Http\Resources\ExportMapTemplateResource;
use App\Models\ExportMapTemplate;

class ExportMapTemplateController extends Controller
{
    public function index(ExportMapTemplateRequest $request): ExportMapTemplateList
    {
        return new ExportMapTemplateList(ExportMapTemplate::query()->latest()->paginate());
    }

    public function show(
        ExportMapTemplateRequest $request,
        ExportMapTemplate $exportMapTemplate
    ): ExportMapTemplateResource {
        return new ExportMapTemplateResource($exportMapTemplate);
    }

    public function store(StoreExportMapTemplate $request): ExportMapTemplateResource
    {
        $exportMapTemplate = ExportMapTemplate::query()->create([
            'title' => $request->input('title'),
            'is_published' => false,
        ]);
        return new ExportMapTemplateResource($exportMapTemplate);
    }

    public function update(
        UpdateExportMapTemplate $request,
        ExportMapTemplate $exportMapTemplate
    ): ExportMapTemplateResource {
        $exportMapTemplate->update($request->validated());
        return new ExportMapTemplateResource($exportMapTemplate);
    }

    public function destroy(
        ExportMapTemplateRequest $request,
        ExportMapTemplate $exportMapTemplate
    ): ExportMapTemplateList {
        $exportMapTemplate->delete();
        return $this->index($request);
    }
}
