<?php

namespace App\Http\Resources;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\VehicleReservations\ReservationStatus;

class ReservationStatusList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        if ($this->resource instanceof LengthAwarePaginator) {
            $this->resource
                ->through(fn(ReservationStatus $reservationStatus) => $this->mapRecord($reservationStatus));
        } else {
            $this->resource = $this->resource
                ->map(fn(ReservationStatus $reservationStatus) => $this->mapRecord($reservationStatus));
        }

        return parent::toArray($request);
    }

    private function mapRecord($reservationStatus)
    {
        return [
            'title' => $reservationStatus->name,
            'metaItems' => [],
            'link' => '/manage-content/reservation-statuses/edit/' . $reservationStatus->id,
            'id' => $reservationStatus->id,
        ];
    }
}
