<?php

namespace App\Jobs;

use App\Services\Occupop;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\PropertyCategory;

class ImportOccupopJobs implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct()
    {
        $this->onQueue('sync');
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        /** @var Occupop $api */
        $api = App::make(Occupop::class);
        $careers = PropertyCategory::firstOrCreate([
            'name' => 'Careers',
            'slug' => 'careers',
        ]);

        $jobs = $api->getJobs();
        foreach ($jobs as $job) {
            $property = $careers->properties()->firstOrCreate([
                'name' => $job['title']
            ]);

            foreach ($careers->fields as $field) {
                $value = match ($field['slug']) {
                    'content' => str_replace(
                        [
                            '&nbsp;',
                            '<p>&nbsp;</p>',
                            '<p><br></p>',
                            '<p class="ql-align-center"><br></p>',
                            '<strong></strong>',
                            '<p class="ql-align-center"></p>',
                            '<p></p>',
                        ],
                        '',
                        $job['description']
                    ),
                    'location', 'location-1' => $job['city_name'],
                    'contract-type', 'contract-type-1' => ucfirst($job['period']),
                    'salary', 'salary-1' => !empty($job['start_salary']) && !empty($job['end_salary'])
                        ? $job['start_salary'] . ' - ' . $job['end_salary']
                        : 'DOE',
                    'category', 'category-1' => ucfirst($job['type']),
                    'contact-email', 'contact-email-1' => '',
                    default => null,
                };

                if (!empty($value)) {
                    $property->attributeValues()
                        ->updateOrCreate([
                            'field_id' => $field['id']
                        ], [
                            'field_id' => $field['id'],
                            'slug' => $field['slug'],
                            'type' => $field['type'],
                            $this->attributeValueColumn($field) => $value,
                        ]);
                }
            }
        }
    }

    private function attributeValueColumn($attribute): string
    {
        return match ($attribute->type) {
            'image', 'editor' => 'value_text',
            'number' => 'value_float',
            'datetime' => 'value_datetime',
            default => 'value',
        };
    }
}
