<?php

namespace App\Listeners;

use App\Modules\Stock\Pinewood;
use App\Services\PinewoodCrmApi;

class AddPinewoodDealershipFields
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(private readonly Pinewood $pinewood, private readonly PinewoodCrmApi $crmApi)
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return array
     */
    public function handle($event)
    {
        $fields = [];
        if ($this->pinewood->enabled()) {
            $fields = $this->pinewood->dealershipAdditionalDataFields();
        }

        if ($this->crmApi->enabled()) {
            $fields = array_merge($fields, $this->crmApi->dealershipAdditionalDataFields());
        }
        return $fields;
    }
}
