<?php

namespace App\Modules\Sales\Config;

use App\Facades\Settings;

class SilverBulletConfig
{
    public function enabled(): bool
    {
        return Settings::get('sales-silver-bullet-enabled') ?? false;
    }

    public function ftpUsername(): string
    {
        return Settings::get('sales-silver-bullet-ftp-username', '');
    }

    public function exportFilename(): string
    {
        return Settings::get('sales-silver-bullet-export-filename') . '.csv';
    }

    public function domain(): string
    {
        return Settings::get('sales-silver-bullet-domain', '');
    }

    public function ftpPassword(): string
    {
        return Settings::get('sales-silver-bullet-ftp-password', '');
    }

    public function term(): int
    {
        return (int)Settings::get('sales-silver-bullet-term');
    }

    public function deposit(): int
    {
        return (int)Settings::get('sales-silver-bullet-deposit');
    }

    public function annualMileage(): int
    {
        return (int)Settings::get('sales-silver-bullet-annual-mileage');
    }

    public function siteName(): string
    {
        return Settings::get('sales-silver-bullet-site-name', '');
    }

    public function campaignName(): string
    {
        return Settings::get('sales-silver-bullet-campaign-name', '');
    }
}
