<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutomotiveLoadMoreSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Enable Load More',
                'config_key' => 'automotive-enable_load_more',
                'type' => 'boolean',
                'value' => false,
                'description' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Load More Text',
                'config_key' => 'automotive-load_more_text',
                'type' => 'text',
                'value' => 'Load More',
                'description' => '',
                'validation_rules' => [
                    "required_if:values.automotive-enable_load_more,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Load More Previous Text',
                'config_key' => 'automotive-load_more_previous_text',
                'type' => 'text',
                'value' => 'Load Previous',
                'description' => '',
                'validation_rules' => [
                    "required_if:values.automotive-enable_load_more,true"
                ]
            ],
        ];
    }
}
