<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class UpdateDealerWebLmsSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Delete the old setting
        Settings::delete('dealerweblms-dealerid');

        // Add the new setting as a replacement
        Settings::make($this->data());
    }

    /**
     * Provides the data for updating dealer web LMS settings.
     *
     * @return array The data to be used for updating the settings.
     */
    private function data()
    {
        return [
            'tab' => 'CRM',
            'section' => 'Integrations',
            'group' => 'Dealer Web LMS',
            'name' => 'Dealer No',
            'config_key' => 'dealerweblms-dealer-no',
            'type' => 'string',
            'value' => '',
            'description' => 'The Dealer Number used for integration.'
        ];
    }
}
