<?php

namespace App\Http\Requests;

use App\Enums\MappingOperator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Validator;

class UpdateExportMap extends UpdateExportMapTemplate
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'type' => ['sometimes', 'string', Rule::in(['vehicle'])],
            'columns' => ['required', 'array', 'min:1'],
            'columns.*' => ['required', 'string'],
            'headers' => ['nullable', 'array'],
            'headers.*' => ['nullable', 'string'],
            'mapping_rules' => ['nullable', 'array'],
            'mapping_rules.*.when' => ['required', 'array'],
            'mapping_rules.*.when.field' => ['required', 'string'],
            'mapping_rules.*.when.op' => ['required', 'string', Rule::in(MappingOperator::values())],
            'mapping_rules.*.when.value' => ['nullable'],
            'mapping_rules.*.then' => ['required', 'array', 'min:1'],
            'mapping_rules.*.then.*.action' => ['required', 'string', Rule::in(['set'])],
            'mapping_rules.*.then.*.target' => ['required', 'string'],
            'mapping_rules.*.then.*.value' => ['nullable'],
            'ftp_export_enabled' => ['required', 'boolean'],
            'driver' => ['required_if:ftp_export_enabled,true', 'nullable', 'string', 'max:255'],
            'host' => ['required_if:ftp_export_enabled,true', 'nullable', 'string', 'max:255'],
            'port' => ['nullable', 'integer'],
            'root' => ['required_if:ftp_export_enabled,true', 'nullable', 'string', 'max:255'],
            'username' => ['required_if:ftp_export_enabled,true', 'nullable', 'string', 'max:255'],
            'password' => ['required_if:ftp_export_enabled,true', 'nullable', 'string', 'max:255'],
            'filename' => ['required_if:ftp_export_enabled,true', 'nullable', 'string', 'max:255'],
            'schedule_enabled' => ['required', 'boolean'],
            'schedule' => ['required_if:schedule_enabled,true', 'nullable', 'string', Rule::in([
                'daily',
                'weekly',
                'biweekly',
                'monthly'
            ])],
            'export_time' => ['required_if:schedule_enabled,true', 'nullable', 'date_format:H:i'],
            'export_day_of_week' => [
                'nullable',
                'integer',
                'between:1,7',
                Rule::requiredIf(fn () => $this->input('schedule_enabled') &&
                    in_array($this->input('schedule'), ['weekly', 'biweekly'])),
            ],
            'export_day_of_month' => [
                'nullable',
                'integer',
                'between:1,31',
                Rule::requiredIf(fn () => $this->input('schedule_enabled') &&
                    $this->input('schedule') === 'monthly'),
            ],
        ];
    }
}
