<?php

namespace Tests\Tenant;

use App\Jobs\ProcessMediaUseChunkJob;
use App\VehicleSpec\Jobs\FetchVehicleSpecData;
use Database\Seeders\Tenant\VehicleSpecSeeder;
use Illuminate\Support\Facades\Queue;
use Mtc\MercuryDataModels\Media;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class VehicleControllerTest extends TenantTestCase
{
    use UserForTenant;

    public function testMediaRecrop()
    {
        $this->seed(VehicleSpecSeeder::class);

        Queue::fake();

        $vehicle = Vehicle::factory()->create();
        $media = Media::factory(3)->create();
        foreach ($media as $medium) {
            $vehicle->mediaUses()->create(['media_id' => $medium->id]);
        }

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.vehicles.media-recrop', $vehicle));

        $response->assertStatus(200);
        Queue::assertPushed(ProcessMediaUseChunkJob::class);
    }
}
