<?php

namespace App\Http\Controllers;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Mtc\MercuryDataModels\FuelType;

class FuelTypeController extends Controller
{
    /**
     * Display a listing of fuel types
     *
     * @return LengthAwarePaginator
     */
    public function index()
    {
        return FuelType::query()->orderBy('name')->paginate();
    }

    /**
     * Display the specified fuel type.
     *
     * @param  FuelType $fuel_type
     * @return FuelType
     */
    public function show(FuelType $fuel_type)
    {
        return $fuel_type;
    }
}
