<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class StockSyncFrequencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'DMS vehicle sync',
            'group' => 'General',
            'name' => 'Sync frequency',
            'config_key' => 'stock-sync-frequency',
            'type' => 'string',
            'value' => 'twice-daily',
            'choices' => [
                ['value' => 'daily', 'name' => 'Once per day (10am GMT)'],
                ['value' => 'twice-daily', 'name' => 'Twice daily (9am & 5pm GMT)'],
                ['value' => 'every-two-hours', 'name' => 'Every two hours'],
                ['value' => 'every-hour', 'name' => 'Every hour'],
            ],
            'superadmin' => true,
            'description' => 'How often to perform stock sync',
        ]);
    }
}
