<?php

namespace App\Imports;

use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Mtc\MercuryDataModels\SeoData;

class SeoDataImport implements ToModel, WithHeadingRow
{
    public function model(array $row)
    {
        try {
            SeoData::query()
                ->updateOrCreate([
                    'path' => $row['path']
                ], [
                    'title' => $row['title'] ?? null,
                    'description' => $row['description'] ?? null,
                    'heading' => $row['heading'] ?? null,
                ]);
        } catch (\Exception $exception) {
            Log::debug('Failed to import row for ' . $row['path'] . ' with exception: ' . $exception->getMessage());
        }
    }
}
