<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use App\Services\CloudflareService;

class CloudflareConfigured extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::DOMAINS;
    }

    public function key(): string
    {
        return 'cloudflare_configured';
    }

    public function handle(): bool
    {
        $has_cloudflare = tenant('has_cloudflare');
        if (!$has_cloudflare) {
            $this->failure_reason = __('go-live.errors.cloudflare-not-enabled');
            return false;
        }

        $cloudflare = (new CloudflareService())->clear(tenant());
        if (!$cloudflare->successful()) {
            $this->failure_reason = __('go-live.errors.cloudflare-request-failed', [
                'status' => $cloudflare->status()
            ]);
            return false;
        }
        return true;
    }
}
