<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use App\Facades\Settings;

class SiteNameCheck extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::CONFIGURATION;
    }

    public function key(): string
    {
        return 'site_name';
    }

    public function handle(): bool
    {
        $has_name = !empty(Settings::get('app-name'));
        if (!$has_name) {
            $this->failure_reason = __('go-live.errors.no-site-name-set');
        }
        return $has_name;
    }
}
