<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreOfferTypeRequest;
use App\Http\Requests\UpdateOfferTypeRequest;
use App\Http\Resources\OfferTypeList;
use App\Http\Resources\OfferTypeView;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\OfferType;

class OfferTypeController extends Controller
{
    /**
     * Display a listing of the offer types.
     *
     * @param Request $request
     * @return OfferTypeList
     */
    public function index(Request $request): OfferTypeList
    {
        return new OfferTypeList(OfferType::query()->with('parent')->paginate());
    }

    /**
     * Store a newly created offer type
     *
     * @param StoreOfferTypeRequest $request
     * @return OfferTypeView
     */
    public function store(StoreOfferTypeRequest $request): OfferTypeView
    {
        $type = OfferType::query()->create($request->validated());

        return new OfferTypeView($type->refresh());
    }

    /**
     * Display the specified offer type.
     *
     * @param OfferType $offerType
     * @return OfferTypeView
     */
    public function show(OfferType $offerType): OfferTypeView
    {
        return new OfferTypeView($offerType);
    }

    /**
     * Update the specified offer types
     *
     * @param UpdateOfferTypeRequest $request
     * @param OfferType $offerType
     * @return OfferTypeView
     */
    public function update(UpdateOfferTypeRequest $request, OfferType $offerType): OfferTypeView
    {
        $offerType->fill($request->validated());
        $offerType->save();

        return new OfferTypeView($offerType);
    }

    /**
     * Remove the specified offer types
     *
     * @param \Mtc\MercuryDataModels\VehicleOffer $vehicleOffer
     * @return bool
     */
    public function destroy(OfferType $offerType): ?bool
    {
        return $offerType->delete();
    }
}
