<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Middleware\TrustProxies as Middleware;
use Illuminate\Support\Facades\Session;

class CurrentTenantMiddleware extends Middleware
{
    public function handle(\Illuminate\Http\Request $request, Closure $next, ...$guards)
    {
        if (tenant('id')) {
            Session::put('current_tenant', tenant('id'));
        }
        return $next($request);
    }
}
