<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class HeyCarExportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Hey Car',
                'name' => 'Enabled',
                'config_key' => 'sales-channels-hey-car-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Hey Car',
                'name' => 'FTP server Username',
                'config_key' => 'sales-channels-hey-car-ftp-username',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-hey-car-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Hey Car',
                'name' => 'FTP server Password',
                'config_key' => 'sales-channels-hey-car-ftp-password',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-hey-car-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Hey Car',
                'name' => 'Vehicle export file name',
                'config_key' => 'sales-channels-hey-car-file-name',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-hey-car-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Hey Car',
                'name' => 'Dealership export file name',
                'config_key' => 'sales-channels-hey-car-dealership-file-name',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-hey-car-enabled,true"
                ]
            ],
        ];
    }
}
