<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\CarGurusExportJob;
use App\Traits\ChecksForExportMap;
use Illuminate\Foundation\Bus\DispatchesJobs;

class CarGuru implements SalesChannel
{
    use DispatchesJobs;
    use ChecksForExportMap;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-car-gurus-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.car_guru');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled() && !$this->hasActiveExportMap()) {
            $this->dispatch(new CarGurusExportJob());
        }
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields()
    {
        return [
            'car-guru-dealer-id' => [
                'type' => 'text',
                'label' => 'Dealership ID on CarGuru'
            ],
        ];
    }
}
