<?php

namespace App\ReportTypes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\Vehicle;

class VehicleReport
{
    /**
     * Report name
     *
     * @return string
     */
    public function name(): string
    {
        return 'Vehicles';
    }

    /**
     * Columns that can be used
     *
     * @return string[]
     */
    public function columns(): array
    {
        return [
            'id' => 'Vehicle ID',
            'uuid' => 'UUID (Stock reference)',
            'registration_number' => 'Registration number (with spaces)',
            'vrm_condensed' => 'Registration number (no spaces)',
            'vin' => 'VIN',
            'is_published' => 'Is Published',
            'is_sold' => 'Is Sold',
            'is_demo' => 'Is Demo',
            'is_reserved' => 'Is Reserved',
            'is_new' => 'Is New',
            'type' => 'Type',
            'title' => 'Title',
            'derivative' => 'Derivative',
            'make.name' => 'Vehicle make',
            'model.name' => 'Vehicle model',
            'fuelType.name' => 'Fuel Type',
            'drivetrain.name' => 'Drivetrain',
            'transmission.name' => 'Transmission',
            'dealership.name' => 'Dealership',
            'bodyStyle.name' => 'Body Style',
            'price' => 'Price',
            'monthly_price' => 'Monthly Price',
            'deposit' => 'Deposit',
            'colour' => 'Colour',
            'odometer_mi' => 'Odometer (miles)',
            'odometer_km' => 'Odometer (km)',
            'engine_size_cc' => 'Engine size (cc)',
            'co2' => 'CO2',
            'mpg' => 'MPG',
            'previous_owner_count' => 'Previous owner count',
            'mediaUses.count' => 'Image count',
            'mediaUses.url' => 'Image URLs',
            'main_video_url' => 'Video URL',
            'allEnquiries.count' => 'Total Enquiry Count',
            'currentMonthEnquiries.count' => 'Enquiry Count This month',
            'created_at_since' => 'Days In Stock',
            'cap_id' => 'CAP ID',
            'auto_trader_id' => 'AutoTrader ID',
            'dateCreated' => 'Date Created',
            'engineSizeLitres' => 'Engine Size (L)',
            'last24HoursEnquiries.count' => 'Enquiries in last 24 hours',
            'odometerUnits' => 'Odometer Units',
            'registrationYear' => 'Registration Year',
            'hasVideo' => 'Has Video',
            'videoCount' => 'Video Count',
            'impressions' => 'Impressions',
        ];
    }

    /**
     * Start a query
     *
     * @return Builder
     */
    public function query(): Builder
    {
        return Vehicle::query();
    }
}
