<?php

namespace App\Services;

use Illuminate\Http\Client\Response;
use Illuminate\Support\Facades\Http;

class AutoTraderAIApi extends AutoTraderApi
{
    protected function cacheName(string $key): string
    {
        return 'auto-trader-ai-api' . $key;
    }

    public function patchVehicle(string $stockId, array $payload, ?string $advertiserId = null): Response
    {
        $params = [
            'advertiserId' => $advertiserId,
        ];
        $url = "stock/" . $stockId . '?' . http_build_query($params);
        return $this->patch($url, $payload);
    }

    public function patch(string $path, $data): Response
    {
        return Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->accessToken()
        ])->patch($this->endpoint($path), $data);
    }
}
