<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FilterPerPageOverrideSettings extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Search results per page',
                'config_key' => 'filter-search-results-per-page',
                'type' => 'int',
                'value' => 15,
                'order' => 11,
                'description' => 'Number of search results displayed per page'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Offers per page',
                'config_key' => 'filter-offers-per-page',
                'type' => 'int',
                'value' => 15,
                'order' => 11,
                'description' => 'Number of offers displayed per page'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'New Vehicles per page',
                'config_key' => 'filter-new-vehicles-per-page',
                'type' => 'int',
                'value' => 15,
                'order' => 11,
                'description' => 'Number of new vehicles displayed per page'
            ],
        ];
    }
}
