<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class GoogleExportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {

        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Google',
                'name' => 'Enabled',
                'config_key' => 'sales-channels-google-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => $this->getDescription(),
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Google',
                'name' => 'Store Code',
                'config_key' => 'sales-channels-google-store-code',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-google-enabled,true"
                ]
            ],
        ];
    }

    private function getDescription()
    {
        return 'Google  feed. '
            . 'When enabled, will grant access to URL for generating/downloading a feed directly from the browser<br/>'
            . 'GET ' . route('tenant.feeds.google', ['tenant' => tenant('id'), 'api_token' => config('auth.api_auth_token')]) . ' to display current vehicles on site<br/><br/>
            
            To download, append &download=true to the URL
            ';
    }
}
