<?php

namespace Tests\Feature\Controllers;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\Currency;
use Tests\TestCase;
use Tests\UserForTenant;

class CurrencyControllerTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    protected bool $tenancy_make_databases = false;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testIndex()
    {
        Currency::factory()->create(['code' => 'USD']);
        Currency::factory()->create(['code' => 'EUR']);
        Currency::factory()->create(['code' => 'JPY']);

        $response = $this->actingAs($this->getUser(false))
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.currencies.index'));

        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertCount(3, $response->json());
        $this->assertArrayHasKey('code', $response->json('0'));
        $this->assertArrayHasKey('ratio', $response->json('0'));
    }
}
