<?php

namespace Tests\Feature;

use App\Facades\Settings;
use App\Facades\Site;
use App\Notifications\PageVersionMarkedChangesRequested;
use App\Notifications\PageVersionMarkedToBeReviewed;
use App\PageRepository;
use Database\Seeders\MercuryTheme\ContentElementSeeder;
use Database\Seeders\MercuryTheme\TemplateSeeder;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Notification;
use Mtc\ContentManager\Models\Page;
use Mtc\MercuryDataModels\PageVersion;
use Tests\TestCase;
use Tests\UserForTenant;

class SiteRepositoryTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    protected bool $tenancy_make_databases = false;

    public function testGetSiteUrl()
    {
        tenant()->domains()->update([
            'verified' => true,
        ]);
        $url = Site::url('/foo');

        $this->assertEquals('https://test.localhost/foo', $url);
    }
}
