<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\CarSnipExportJob;
use App\Modules\SalesChannels\CarSnip;
use Database\Seeders\Tenant\CarSnipExportSeeder;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class CarSnipExportTest extends TenantTestCase
{

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('car-snip-export');
        (new CarSnipExportSeeder())->run();
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-car-snip-file-name', 'foo.csv');

        (new CarSnipExportJob())->handle();

        Storage::disk('car-snip-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'car-snip')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }

    public function testSalesChannelClass()
    {
        Bus::fake();
        Storage::fake('car-snip-export');
        (new CarSnipExportSeeder())->run();
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-car-snip-file-name', 'foo.csv');
        Settings::update('sales-channels-car-snip-enabled', true);

        app(CarSnip::class)->runScheduledExport();
        Bus::assertDispatched(CarSnipExportJob::class);
        (new CarSnipExportJob())->handle();

        Storage::disk('car-snip-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'car-snip')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }
}
