<?php

namespace Tests\Tenant\Controllers;

use Mtc\MercuryDataModels\Enquiry;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class EnquiryControllerTest extends TenantTestCase
{
    use UserForTenant;

    public function testEnquiryView()
    {
        $enquiry = Enquiry::factory()->create();

        $response = $this->actingAs($this->getUser(false))
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('enquiries.show', $enquiry));
        $response->assertStatus(200);
        $this->assertArrayHasKey('id', $response->json('enquiry'));
        $this->assertArrayHasKey('title', $response->json('enquiry'));
        $this->assertArrayHasKey('message', $response->json('enquiry'));
        $this->assertArrayHasKey('enquiry', $response->json());
        $this->assertArrayHasKey('statuses', $response->json());
        $this->assertArrayHasKey('managers', $response->json());
    }

}
