<?php

namespace Tests\Tenant\Controllers;

use Mtc\MercuryDataModels\KeyloopLeaseVehicleVariant;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class LeaseVehicleControllerTest extends TenantTestCase
{
    use UserForTenant;

    public function testVariantList()
    {
        KeyloopLeaseVehicleVariant::factory(5)->create([
            'featured' => true,
        ]);

        $response = $this->actingAs($this->getUser(false))
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.lease-vehicles.list'));

        $response->assertStatus(200);

        $this->assertCount(5, $response->json('data'));
        $this->assertArrayHasKey('featured', $response->json('data.0'));
        $this->assertTrue($response->json('data.0.featured'));
    }

    public function testFilterVariantList()
    {
        $make = VehicleMake::factory()->create();
        $model = VehicleModel::factory()->create([
            'make_id' => $make->id,
        ]);

        KeyloopLeaseVehicleVariant::factory(1)->create([
            'make_id' => $make->id + 1,
        ]);

        KeyloopLeaseVehicleVariant::factory(5)->create([
            'make_id' => $make->id,
            'model_id' => $model->id,
        ]);

        KeyloopLeaseVehicleVariant::factory(3)->create([
            'make_id' => $make->id,
            'model_id' => $model->id + 1,
        ]);

        $response = $this->actingAs($this->getUser(false))
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.lease-vehicles.list', [
                'selections' => [
                    [
                        'type' => 'make_id',
                        'id' => $make->id,
                    ],
                    [
                        'type' => 'model_id',
                        'id' => $model->id,
                    ],
                ],
            ]));

        $response->assertStatus(200);

        $this->assertCount(5, $response->json('data'));
    }

    public function testFeaturedUpdate()
    {
        $vehicle_one = KeyloopLeaseVehicleVariant::factory()->create([
            'featured' => false,
        ]);

        $vehicle_two = KeyloopLeaseVehicleVariant::factory()->create([
            'featured' => true,
        ]);

        $response = $this->actingAs($this->getUser(false))
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.lease-vehicles.update'), [
                'vehicles' => [
                    [
                        'id' => $vehicle_one->id,
                        'featured' => true,
                    ],
                    [
                        'id' => $vehicle_two->id,
                        'featured' => false,
                    ],
                ],
            ]);

        $response->assertStatus(200);

        $this->assertTrue(KeyloopLeaseVehicleVariant::find($vehicle_one->id)->featured);
        $this->assertFalse(KeyloopLeaseVehicleVariant::find($vehicle_two->id)->featured);
    }
}
