<?php

namespace Tests\Tenant\Controllers;

use App\Facades\Settings;
use Database\Seeders\Tenant\RapidRTCSettingSeeder;
use Mtc\MercuryDataModels\Dealership;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class SendToRapidRTCControllerTest extends TenantTestCase
{
    use UserForTenant;

    protected bool $mockCountryFacade = true;

    /**
     * A basic unit test example.
     *
     * @return void
     */
    public function testShowDealerHasRapidRtcField()
    {
        $this->seed(RapidRTCSettingSeeder::class);
        Settings::update('crm-rapid-rtc-enabled', true);

        $dealership = Dealership::factory()->create(['name' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.dealerships.show', $dealership->id));

        $response->assertStatus(200);
        $this->assertIsArray($response->json('dealership.data_fields'));
        $this->assertEquals('rapid-rtc-mailbox', $response->json('dealership.data_fields.0.id'));
    }

    public function testUpdateDealerChecksRapidRtcFields()
    {
        $this->seed(RapidRTCSettingSeeder::class);
        Settings::update('crm-rapid-rtc-enabled', true);

        $dealership = Dealership::factory()->create(['name' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->putJson(route('tenant.dealerships.update', $dealership->id), [
                'name' => 'baz',
                'email' => 'john@example.com',
                'contact_no' => '123123',
                'address1' => 'foo',
                'address2' => 'baz',
                'city' => 'bar',
                'county' => 'foo-baz',
                'postcode' => '1004',
                'country' => 'LV',
            ]);

        $response->assertStatus(422);
        $this->assertArrayHasKey('data.rapid-rtc-mailbox', $response->json('errors'));
    }
}
