<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use Illuminate\Support\Facades\Storage;
use Tests\TenantTestCase;

class EasiChatFeedTest extends TenantTestCase
{
    protected $route;

    public function setUp(): void
    {
        parent::setUp();
        Storage::fake('public');

        $this->route = route('tenant.feeds.easichat', tenant('id')) . '?api_token=' . config('auth.api_auth_token');
    }

    public function testUnauthorizedAccessReturns401()
    {
        $response = $this->get(route('tenant.feeds.easichat', tenant('id')) . '?api_token=invalid');

        $response->assertStatus(401);
    }

    public function testDisabledFeedReturns404()
    {
        Settings::shouldReceive('get')
            ->with('sales-channels-easichat-enabled', false)
            ->andReturn(false);

        $response = $this->get($this->route);

        $response->assertStatus(404);
    }

    public function testCanViewFeed()
    {
        Settings::shouldReceive('get')
            ->with('sales-channels-easichat-enabled', false)
            ->andReturn(true);

        $response = $this->get($this->route);

        $response->assertStatus(200);
        $response->assertSee(['Vehicle_ID', 'Vehicle_Reg', 'Colour', 'FuelType', 'Mileage']);
    }

    public function testCanDownloadFeed()
    {
        Settings::shouldReceive('get')
            ->with('sales-channels-easichat-enabled', false)
            ->andReturn(true);

        $response = $this->get($this->route . '&download=true');

        $response->assertStatus(200);
        $response->assertHeader('Content-Type', 'text/csv; charset=UTF-8');
        $response->assertHeader('Content-Disposition', 'attachment; filename=easichat_stock.csv');
    }

}
