<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\MotoNovoExportJob;
use App\Modules\SalesChannels\MotoNovo;
use Database\Seeders\Tenant\MotoNovoExportSeeder;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class MotoNovoExportTest extends TenantTestCase
{

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('moto-novo-export');
        $this->seed(MotoNovoExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-moto-novo-file-name', 'foo.csv');

        (new MotoNovoExportJob())->handle();

        Storage::disk('moto-novo-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'moto-novo')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }

    public function testSalesChannelClass()
    {
        Bus::fake();
        Storage::fake('moto-novo-export');
        $this->seed(MotoNovoExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-moto-novo-file-name', 'foo.csv');
        Settings::update('sales-channels-moto-novo-enabled', true);

        app(MotoNovo::class)->runScheduledExport();
        Bus::assertDispatched(MotoNovoExportJob::class);

        (new MotoNovoExportJob())->handle();

        Storage::disk('moto-novo-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'moto-novo')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }
}
