<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\ImportImagesFromUrlList;
use App\Modules\Stock\Skupenet;
use App\VehicleType;
use Illuminate\Http\Client\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Queue;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class SkupenetTest extends TenantTestCase
{
    public function testImport()
    {
        Queue::fake();
        Http::fake([
            'https://feeds.dealerhub.ie/api/v1/stock?*' => Http::response($this->response()),
            "*" => Http::response([], 400),
        ]);
        Settings::make([
            'tab' => 'foo',
            'section' => 'foo',
            'group' => 'foo',
            'name' => 'foo',
            'config_key' => 'app-details-currency',
            'value' => 'GBP',
            'type' => 'string'
        ]);

        Settings::make([
            'tab' => 'foo',
            'section' => 'foo',
            'group' => 'foo',
            'name' => 'foo',
            'config_key' => 'stock-skupenet-sync-images',
            'value' => true,
            'type' => 'boolean'
        ]);

        Dealership::factory()->create(['data' => ['skupenet-location-id' => 123]]);
        (new Skupenet())->runScheduledImport();

        Http::assertSent(function (Request $request) {
            return $request->url() === 'https://feeds.dealerhub.ie/api/v1/stock?dealerIds=123&pageSize=50&page=1';
        });
        $this->assertEquals(4, Vehicle::query()->count());
        $this->assertTrue(Vehicle::query()->where('vrm_condensed', '212D1122')->exists());

        $this->assertEquals(
            VehicleType::CAR->value,
            Vehicle::where('uuid', 123)->first()->type
        );

        $this->assertEquals(
            VehicleType::LCV->value,
            Vehicle::where('uuid', 333)->first()->type
        );

        $this->assertEquals(
            VehicleType::MOTORCYCLE->value,
            Vehicle::where('uuid', 444)->first()->type
        );
        Queue::assertPushed(ImportImagesFromUrlList::class);
    }

    private function response(): array
    {
        return [
            'stock' => [
                [
                    'id' => 123,
                    'dhfDealerId' => 123,
                    'price' => 11223,
                    'currency' => 'GBP',
                    'stockType' => 'CARS',
                    'description' => 'lorem ipsum dolor sit amet',
                    'attributes' => [
                        'registration' => '212D1122',
                        'make' => 'Volkswagen',
                        'model' => 'ID.5',
                        'trim' => 'MAX',
                        'bodyType' => 'Sedan',
                    ],
                    'images' => [
                        [
                            'url' => 'a.com/123',
                        ],
                        [
                            'url' => 'a.com/222',
                        ],
                    ],
                ],
                [
                    'id' => 222,
                    'dhfDealerId' => 123,
                    'price' => 13443,
                    'currency' => 'GBP',
                    'stockType' => 'CARS',
                    'description' => 'lorem ipsum dolor sit amet',
                    'attributes' => [
                        'registration' => '214D1422',
                        'make' => 'Ford',
                        'model' => 'Focus',
                        'bodyType' => 'Sedan',
                    ],
                ],
                [
                    'id' => 333,
                    'dhfDealerId' => 123,
                    'price' => 13443,
                    'currency' => 'GBP',
                    'stockType' => 'COMMERCIALS',
                    'description' => 'lorem ipsum dolor sit amet',
                    'attributes' => [
                        'registration' => '214D1422',
                        'make' => 'Ford',
                        'model' => 'Transit',
                        'bodyType' => 'Commercial/Van',
                    ],
                ],
                [
                    'id' => 444,
                    'dhfDealerId' => 123,
                    'price' => 900,
                    'currency' => 'GBP',
                    'stockType' => 'bike',
                    'description' => 'test bike',
                    'attributes' => [
                        'registration' => 'BIKE123',
                        'make' => 'Yamaha',
                        'model' => 'MT-07',
                    ],
                ],
            ],
            'paging' => [
                'totalPages' => 1,
            ],
        ];
    }
}
