<?php

namespace Tests;

class TestSettingRepository
{
    private $loaded_settings = [];

    public function make(array $setting, bool $withValue = false)
    {
        if (($setting['type'] ?? null) == 'image') {
            $this->loaded_settings[$setting['config_key']] = [
                'url' => $setting['value'] ?? '',
                'path' =>  $setting['value'] ?? '',
            ];

        } else {
            $this->loaded_settings[$setting['config_key']] = $setting['value'] ?? null;
        }
    }

    public function exists(string $key): bool
    {
        return isset($this->loaded_settings[$key]);
    }

    public function get(string $key, $default = null)
    {
        return $this->loaded_settings[$key] ?? $default;
    }

    public function update(string $key, $value)
    {
        $this->loaded_settings[$key] = $value;
    }

    /**
     * @param string $key
     * @return void
     */
    public function delete(string $key): void
    {
        unset($this->loaded_settings[$key]);
    }
}
