<?php

namespace App\Listeners;

use App\Events\NewVehicleImported;
use App\Facades\Settings;
use App\Modules\ImageSync\AutosOnShow;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\ApiNotification;

class AutosOnShowNotificationResetOnNewVehicle
{
    use DispatchesJobs;

    /**
     * Handle the event.
     */
    public function handle(NewVehicleImported $event): void
    {
        if (Settings::get('image-sync-autos-on-show-enabled')) {
            $notification = ApiNotification::query()
                ->where('provider', AutosOnShow::PROVIDER_NAME)
                ->where(fn($query) =>
                    $query->where('reference', $event->vehicle->vrm_condensed)
                    ->orWhere('reference', $event->vehicle->vin))
                ->latest()
                ->first();

            $notification?->update([
                'processed' => null,
            ]);
        }
    }
}
