<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SalesforceCrmLiveUatSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Force Salesforce test environment',
                'config_key' => 'salesforce-crm-test-mode',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Enable this setting to use the Salesforce CRM test environment on the live Autonomy environment',
            ],
        ];
    }
}
